MOD = 10**9 + 7

def main():
    import sys
    data = sys.stdin.read().split()
    t = int(data[0])
    max_p = 1000000
    max_n = 2 * max_p + 1
    
    fact = [1] * (max_n + 1)
    for i in range(1, max_n + 1):
        fact[i] = fact[i - 1] * i % MOD
        
    inv_fact = [1] * (max_n + 1)
    inv_fact[max_n] = pow(fact[max_n], MOD - 2, MOD)
    for i in range(max_n - 1, -1, -1):
        inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD
        
    power4 = [1] * (max_p + 1)
    for i in range(1, max_p + 1):
        power4[i] = power4[i - 1] * 4 % MOD
        
    index = 1
    results = []
    for _ in range(t):
        p = int(data[index])
        m = int(data[index + 1])
        index += 2
        if p == 0:
            results.append(str(m % MOD))
        else:
            n = 2 * p + 1
            numerator = (2 * p + m + 1) * power4[p] % MOD
            numerator = numerator * fact[p] % MOD
            numerator = numerator * fact[p] % MOD
            denominator = fact[n]
            ans = numerator * inv_fact[denominator] % MOD
            results.append(str(ans))
            
    sys.stdout.write("\n".join(results))
    
if __name__ == "__main__":
    main()
