from collections import Counter

def first_run(n, arr):
    S = sum(arr)
    modn1 = n + 1
    target = S % modn1
    for i, a in enumerate(arr):
        if (2 * a) % modn1 == target:
            return i + 1
    if n > 0:
        target2 = S % n
        for i, a in enumerate(arr):
            if (2 * a) % n == target2:
                return i + 1

    freq = Counter(arr)
    mode_val, _ = freq.most_common(1)[0]
    return arr.index(mode_val) + 1

def second_run(m, visible):
    players = m + 1
    if len(set(visible)) == len(visible):
        g = sum(visible) % players
        if g == 0:
            g = players
        return g
    freq = Counter(visible)
    mode_val, mode_count = freq.most_common(1)[0]
    if mode_count >= m - 1:
        return mode_val
    g = sum(visible) % (players + 1)
    if g == 0:
        g = players + 1
    if 1 <= g <= players:
        return g
    g2 = sum(visible) % players
    if g2 == 0:
        g2 = players
    return g2

def main():
    line = input().strip()
    if line == "":
        return
    run = int(line)
    if run == 0:
        n = int(input().strip())
        arr = list(map(int, input().strip().split()))
        if len(arr) != n:
            arr = arr[:n] + [0]*(n - len(arr))
        chosen = first_run(n, arr)
        print(chosen)
    else:
        m = int(input().strip())
        visible = list(map(int, input().strip().split()))
        if len(visible) != m:
            visible = visible[:m] + [0]*(m - len(visible))
        guess = second_run(m, visible)
        print(guess)

if __name__ == "__main__":
    main()
