﻿#include <iostream>

const long long MOD = 1000000007;

long long power(long long base, long long exp, long long mod) {
    long long res = 1;
    base %= mod;
    while (exp > 0) {
        if (exp & 1) {res = (res * base) % mod;}
        base = (base * base) % mod;
        exp >>= 1;
    }
    return res;
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr);

    int t;
    std::cin >> t;

    while (t--) {
        long long p, m;
        std::cin >> p >> m;

        long long numerator = (2LL * ((p + 1) % MOD) % MOD * ((m + 1) % MOD)) % MOD;
        long long denominator = (p + m + 1) % MOD;

        long long inv_denom = power(denominator, MOD - 2, MOD);
        long long ans = (numerator * inv_denom) % MOD;

        std::cout << ans << std::endl;
    }

    return 0;
}

