#include <iostream>
#include <vector>
using namespace std;

const long long MOD = 1000000007;
const long long P_MAX = 1000000;
const long long INV_MAX = 2 * P_MAX + 1;
vector<long long> fact(INV_MAX + 1);
vector<long long> invFact(INV_MAX + 1);

long long power(long long base, long long exp) {
    long long res = 1;
    base %= MOD;
    while (exp > 0) {
        if (exp % 2 == 1) res = (res * base) % MOD;
        base = (base * base) % MOD;
        exp /= 2;
    }
    return res;
}

long long inv(long long n) {
    return power(n, MOD - 2);
}

void calc() {
    fact[0] = 1;
    invFact[0] = 1;
    for (int i = 1; i <= INV_MAX; i++) {
        fact[i] = (fact[i - 1] * i) % MOD;
        invFact[i] = inv(fact[i]);
    }
}

long long C_mod_p(int n, int k) {
    if (k < 0 || k > n) return 0;
    return (((fact[n] * invFact[k]) % MOD) * invFact[n - k]) % MOD;
}

void solve() {
    long long p, m;
    cin >> p >> m;

    long long term1_num = (2 * p + m + 1) % MOD;
    long long term1_den = (2 * p + 1) % MOD;
    long long term1 = (term1_num * inv(term1_den)) % MOD;
    
    long long term2_num = power(2, 2 * p);
    long long term2_den = C_mod_p(2 * p, p);
    long long term2 = (term2_num * inv(term2_den)) % MOD;
    
    long long EV = (term1 * term2) % MOD;
    cout << EV << endl;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    calc();
    int t; cin >> t;
    while (t--) solve();
}