#include <iostream>
#include <vector>
using namespace std;

const long long MOD = 1000000007;
const long long P_MAX = 1000000;
const long long INV_MAX = 2 * P_MAX + 1;
vector<long long> fact(INV_MAX + 1);
vector<long long> invFact(INV_MAX + 1);

long long power(long long base, long long exp) {
    long long res = 1;
    base %= MOD;
    while (exp > 0) {
        if (exp % 2 == 1) res = (res * base) % MOD;
        base = (base * base) % MOD;
        exp /= 2;
    }
    return res;
}

long long inv(long long n) {
    return power(n, MOD - 2);
}

void calc() {
    fact[0] = 1;
    invFact[0] = 1;
    for (int i = 1; i <= INV_MAX; i++) {
        fact[i] = (fact[i - 1] * i) % MOD;
        invFact[i] = inv(fact[i]);
    }
}

long long C_mod_p(int n, int k) {
    if (k < 0 || k > n) return 0;
    return (((fact[n] * invFact[k]) % MOD) * invFact[n - k]) % MOD;
}

void solve() {
    long long p, m;
    cin >> p >> m;

    long long n = 2 * p + m;
    long long k_max = p + m;

    if (k_max == 0) {
        cout << 1 << endl;
        return;
    }

    vector<long long> U(k_max + 1);
    U[0] = 1, U[1] = n;

    for (long long j = 1; j < k_max; ++j) {
        long long term1 = (2 * p + m - 3 * j) % MOD;
        if (term1 < 0) term1 += MOD;
        
        long long term2 = (2 * p + 2 * m - 2 * j + 2) % MOD;
        if (term2 < 0) term2 += MOD;

        long long rhs = (term1 * U[j]) % MOD;
        rhs = (rhs + (term2 * U[j - 1]) % MOD) % MOD;
        
        U[j + 1] = (rhs * inv(j + 1)) % MOD;
    }

    long long EV = 0;
    for (long long j = 0; j <= k_max; ++j) {
        long long C_inv = inv(C_mod_p(n, j));
        long long term = (U[j] * C_inv) % MOD;
        EV = (EV + term) % MOD;
    }

    cout << EV << endl;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    calc();
    int t; cin >> t;
    while (t--) solve();
}