#include <iostream>
#include <vector>
using namespace std;

const long long MOD = 1000000007;
const long long P_MAX = 1000000;
const long long INV_MAX = 2 * P_MAX + 2;
vector<long long> sum, answers;

long long power(long long base, long long exp) {
    long long res = 1;
    base %= MOD;
    while (exp > 0) {
        if (exp % 2 == 1) res = (res * base) % MOD;
        base = (base * base) % MOD;
        exp /= 2;
    }
    return res;
}

long long inv(long long n) {
    return power(n, MOD - 2);
}

void calc() {
    sum.resize(P_MAX + 1);

    sum[0] = 0;
    for (int p = 1; p <= P_MAX; p++) {
        long long term = inv(2LL * p - 1);
        sum[p] = (sum[p - 1] + term) % MOD;
    }
}

void solve() {
    long long p, m;
    cin >> p >> m;

    long long mod = 1000000007;
    long long r = (4 * p + 2 * m + 2) % mod;
    long long q = (2 * p + 1) % mod;
    long long q_inv = inv(q);
    long long ans = (r * q_inv) % mod;
    if (ans < 0)
        ans += mod;
    answers.push_back(ans);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    calc();
    int t; cin >> t;
    while (t--) solve();

    for (auto a : answers)
        cout << a << endl;

    return 0;
}