#include <iostream>
#include <vector>
using namespace std;

const long long MOD = 1000000007;
const long long P_MAX = 1000000;
const long long INV_MAX = 2 * P_MAX + 2;

vector<long long> inv;
vector<long long> sum;

void calc() {
    inv.resize(INV_MAX);
    sum.resize(P_MAX + 1);

    inv[1] = 1;
    for (int i = 2; i < INV_MAX; i++)
        inv[i] = MOD - ((MOD / i) * inv[MOD % i]) % MOD;

    sum[0] = 0;
    for (int p = 1; p <= P_MAX; p++) {
        long long term = inv[2LL * p - 1];
        sum[p] = (sum[p - 1] + term) % MOD;
    }
}

void solve() {
    long long p, m;
    cin >> p >> m;

    long long sum_val = sum[p];
    long long e_p_0 = (2 * sum_val) % MOD;

    long long num = (2 * p + m + 1) % MOD;
    long long den_inv = inv[2 * p + 1];

    long long ans = e_p_0;
    ans = (ans * num) % MOD;
    ans = (ans * den_inv) % MOD;

    cout << ans << "\n";
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    calc();
    int t; cin >> t;
    while (t--) solve();
    return 0;
}