#include <iostream>
#include <algorithm>
#include <vector>
#include <numeric>
using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n; cin >> n;
    vector<long long> lengths(n);
    long long total_sum = 0;
    for (int i = 0; i < n; ++i) {
        cin >> lengths[i];
        total_sum += lengths[i];
    }

    long long min_area = 2000000000, max_area = 0;
    int limit = 1 << n;
    for (int i = 1; i < limit - 1; ++i) {
        long long sum_a = 0;
        for (int j = 0; j < n; ++j) {
            if ((i >> j) & 1)
                sum_a += lengths[j];
        }

        long long sum_b = total_sum - sum_a;
        long long current_area = sum_a * sum_b;

        if (current_area < min_area)
            min_area = current_area;
        if (current_area > max_area)
            max_area = current_area;
    }

    cout << min_area << " " << max_area << endl;
    return 0;
}