﻿#include <iostream>
#include <vector>
#include <algorithm>
#include <unordered_set>

using namespace std;

int number_of_pairs(const vector<long long> V, long long s)
{
	if (V.size() < 2) return 0;

	int count = 0;

	unordered_multiset<long long> elements(V.begin(), V.end());
	unordered_set<long long> used_elements;

	for (long long a : V)
	{
		if (used_elements.count(a)) continue;

		long long b = s - a;

		if (a != b && elements.count(b) && !used_elements.count(b))
		{
			count++;
			used_elements.insert(a);
			used_elements.insert(b);
		}
	}
	return count;
}


int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);

	vector<long long> V;
	long long s, n;
	cin >> n >> s;

	for (long i = 0; i < n; i++)
	{
		s = (s * 618023 + 1) % 999983;
		int k = number_of_pairs(V, s);
		if (k % 2 == 0)
		{
			V.push_back(s);
		}
	}
	cout << V.size();
	return 0;
}