#include <iostream>
#include <vector>
#include <algorithm>
#include <bitset>
using namespace std;

const int MOD = 999983;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n, s;
    cin >> n >> s;
    
    vector<bool> inV(MOD, false);
    vector<int> V;
    V.reserve(n);
    
    vector<int> s_values(n);
    for (int i = 0; i < n; i++) {
        s = (1LL * s * 618023 + 1) % MOD;
        s_values[i] = s;
    }
    
    for (int i = 0; i < n; i++) {
        s = s_values[i];
        int count = 0;
        int j = 0, k = (int)V.size() - 1;
        while (j <= k) {
            int sum = V[j] + V[k];
            if (sum == s) {
                if (j == k) {
                    count++;
                } else {
                    count += 2;
                }
                j++;
                k--;
            } else if (sum < s) {
                j++;
            } else {
                k--;
            }
        }
        
        if (count % 2 == 0 && !inV[s]) {
            inV[s] = true;
            auto it = lower_bound(V.begin(), V.end(), s);
            V.insert(it, s);
        }
    }
    
    cout << V.size() << endl;
    return 0;
}