#include <iostream>
#include <vector>
using namespace std;

struct Point {
    int x, y;
};

long long dist2(const Point& a, const Point& b) {
    long long dx = a.x - b.x;
    long long dy = a.y - b.y;
    return dx * dx + dy * dy;
}

int main() {
    int n;
    cin >> n;
    vector<Point> points(n);
    for (int i = 0; i < n; i++) {
        cin >> points[i].x >> points[i].y;
    }

    long long max_d2 = 0;
    int a_index = 0, b_index = 0;
    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            long long d2 = dist2(points[i], points[j]);
            if (d2 > max_d2) {
                max_d2 = d2;
                a_index = i;
                b_index = j;
            }
        }
    }

    Point A = points[a_index];
    Point B = points[b_index];
    int dx = B.x - A.x;
    int dy = B.y - A.y;
    int c1 = -dx * A.x - dy * A.y;
    int c2 = -dx * B.x - dy * B.y;

    cout << dx << " " << dy << " " << c1 << endl;
    cout << dx << " " << dy << " " << c2 << endl;

    return 0;
}
