from fractions import Fraction
import math

def expected_first_pair(p, m):
    N = 2 * p + m

    def C(n, k):
        return 0 if k < 0 or k > n else math.comb(n, k)

    E = Fraction(0, 1)
    for k in range(0, N):
        A0 = 0
        rmin = max(0, k - m)
        rmax = min(p, k)
        for r in range(rmin, rmax + 1):
            A0 += C(p, r) * (2 ** r) * C(m, k - r)
        P_gt = Fraction(A0, C(N, k))
        E += P_gt
    return E


def solution(p, m):
    x = expected_first_pair(p, m)
    r = x.numerator
    q = x.denominator
    d = 10 ** 9 + 7
    return (pow(q, d-2, d) * r) % d


t = int(input())
answer = []
for x in range(t):
    answer.append(solution(*map(int, input().split())))

for x in answer:
    print(x)
assert solution(1, 1) == 666666674


