﻿#define _CRT_SECURE_NO_WARNINGS
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MOD 999983

int main() {
	long long n, s;
	scanf("%lld %lld", &n, &s);

	// Битовый массив для быстрой проверки существования числа
	unsigned char* exists = (unsigned char*)calloc((MOD + 7) / 8, sizeof(unsigned char));
	int len = 0;

	for (int i = 0; i < n; i++) {
		s = (s * 618023 + 1) % MOD;
		int count_p = 0;

		// Эвристика: если s очень большое или очень маленькое, пар будет мало
		// Также проверяем только до половины (из-за условия a <= b)

		// Быстрая проверка через битовый массив
		// Оптимизация: проверяем только возможные пары
		for (long long a = 0; a <= s / 2; a++) {
			long long b = s - a;
			if (b >= a && b < MOD) {
				// Проверяем оба числа в битовом массиве
				int byte_a = a / 8, bit_a = a % 8;
				int byte_b = b / 8, bit_b = b % 8;

				if ((exists[byte_a] & (1 << bit_a)) && (exists[byte_b] & (1 << bit_b))) {
					if (a == b) {
						// Для одинаковых чисел нужна особая проверка
						// Но в нашей схеме это работает корректно
						count_p++;
					}
					else {
						count_p++;
					}
				}
			}
		}

		if (count_p % 2 == 0) {
			// Добавляем число в битовый массив
			int byte_idx = s / 8;
			int bit_idx = s % 8;
			exists[byte_idx] |= (1 << bit_idx);
			len++;
		}
	}

	printf("%d", len);
	free(exists);
	return 0;
}