positions = {
    "A": [1, 8, 15, 22, 29, 36, 43, 50],
    "B": [2, 9, 16, 23, 30, 37, 44, 51],
    "C": [3, 10, 17, 24, 31, 38, 45, 52],
    "D": [4, 11, 18, 25, 32, 39, 46],
    "E": [5, 12, 19, 26, 33, 40, 47],
    "F": [6, 13, 20, 27, 34, 41, 48],
    "G": [7, 14, 21, 28, 35, 42, 49]
}

t = int(input())
for _ in range(t):
    melody = input()
    
    current_min = min(positions[melody[0]])
    current_max = max(positions[melody[0]])
    
    possible = True
    for note in melody[1:]:
        note_positions = positions[note]
        
        next_min = float('inf')
        next_max = float('-inf')
        
        for pos in note_positions:
            if (pos >= current_min - 3 and pos <= current_max + 3) or \
               any(abs(pos - p) <= 3 for p in [current_min, current_max]):
                next_min = min(next_min, pos)
                next_max = max(next_max, pos)
        
        if next_min == float('inf'):
            possible = False
            break
        
        current_min, current_max = next_min, next_max
    
    print("Yes" if possible else "No")