import kotlin.math.*

fun main() {
    val input = readLine()!!.split(" ").map { it.toInt() }
    val points = List(4) { i -> 
        Point(input[2*i].toDouble(), input[2*i+1].toDouble())
    }
    
    val width = distance(points[0], points[1])
    val height = distance(points[1], points[2])
    
    val a = max(width, height) / 2.0
    val b = min(width, height) / 2.0
    
    val area = PI * a * b
    println("%.8f".format(area))
}

data class Point(val x: Double, val y: Double)

fun distance(p1: Point, p2: Point): Double {
    return sqrt((p1.x - p2.x).pow(2) + (p1.y - p2.y).pow(2))
}
