def dist_sq(p1, p2):
    return (p1[0] - p2[0])**2 + (p1[1] - p2[1])**2

def solve():
    n = int(input())
    points = []
    for _ in range(n):
        x, y = map(int, input().split())
        points.append((x, y))

    if n == 1:
        print(1, 0, -points[0][0])
        print(1, 0, -points[0][0] + 1)
        return

    if n == 2:
        p1, p2 = points
        dx = p2[0] - p1[0]
        dy = p2[1] - p1[1]
        a = dy
        b = -dx
        c1 = -(a * p1[0] + b * p1[1])
        c2 = -(a * p2[0] + b * p2[1])
        print(a, b, c1)
        print(a, b, c2)
        return

    max_d_sq = -1
    best_pair = (0, 0)

    for i in range(n):
        for j in range(i + 1, n):
            d_sq = dist_sq(points[i], points[j])
            if d_sq > max_d_sq:
                max_d_sq = d_sq
                best_pair = (i, j)

    p1_idx, p2_idx = best_pair
    p1 = points[p1_idx]
    p2 = points[p2_idx]

    dx = p2[0] - p1[0]
    dy = p2[1] - p1[1]

    a = dx
    b = dy
    c1 = -(a * p1[0] + b * p1[1])
    c2 = -(a * p2[0] + b * p2[1])

    all_between = True
    for pt in points:
        val1 = a * pt[0] + b * pt[1] + c1
        val2 = a * pt[0] + b * pt[1] + c2
        if (val1 > 0 and val2 > 0) or (val1 < 0 and val2 < 0):
            all_between = False
            break

    if all_between:
        print(a, b, c1)
        print(a, b, c2)
        return

    best_dist_sq = -1
    best_line1 = None

    for i in range(n):
        for j in range(i + 1, n):
            p1 = points[i]
            p2 = points[j]
            dx = p2[0] - p1[0]
            dy = p2[1] - p1[1]
            a = dy
            b = -dx
            c1 = -(a * p1[0] + b * p1[1])
            c2 = -(a * p2[0] + b * p2[1])

            all_between = True
            for pt in points:
                val1 = a * pt[0] + b * pt[1] + c1
                val2 = a * pt[0] + b * pt[1] + c2
                if (val1 > 0 and val2 > 0) or (val1 < 0 and val2 < 0):
                    all_between = False
                    break

            if not all_between:
                continue

            dist_sq_val = (c1 - c2)**2 / (a*a + b*b)
            if dist_sq_val > best_dist_sq:
                best_dist_sq = dist_sq_val
                best_line1 = (a, b, c1)

    a, b, c1 = best_line1
    print(a, b, c1)
    print(a, b, c2)

solve()