#include <bits/stdc++.h>
using namespace std;

const int MOD = 1e9 + 7;

int modPower(int a, int e) {
    int res = 1;
    while (e) {
        if (e & 1) res = 1LL * res * a % MOD;
        a = 1LL * a * a % MOD;
        e >>= 1;
    }
    return res;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int t;
    cin >> t;
    vector<pair<int, int>> queries(t);
    int max_p = 0;
    for (int i = 0; i < t; i++) {
        int p, m;
        cin >> p >> m;
        queries[i] = {p, m};
        max_p = max(max_p, p);
    }

    int up_to = 2 * max_p + 1;
    vector<int> fact(up_to + 1), inv_fact(up_to + 1);
    fact[0] = 1;
    for (int i = 1; i <= up_to; i++) {
        fact[i] = 1LL * fact[i-1] * i % MOD;
    }
    inv_fact[up_to] = modPower(fact[up_to], MOD - 2);
    for (int i = up_to - 1; i >= 0; i--) {
        inv_fact[i] = 1LL * inv_fact[i+1] * (i+1) % MOD;
    }

    auto nCr = [&](int n, int r) {
        if (r < 0 || r > n) return 0LL;
        return 1LL * fact[n] * inv_fact[r] % MOD * inv_fact[n-r] % MOD;
    };

    for (auto [p, m] : queries) {
        int total = 2 * p + m;
        long long choose = nCr(2 * p + 1, p);

        long long res = (total + 1) % MOD;
        res = res * modPower(4, p) % MOD;
        res = res * modPower(p + 1, MOD - 2) % MOD;
        res = res * modPower(choose, MOD - 2) % MOD;

        cout << res << "\n";
    }
    return 0;
}