import sys


def rot_cw(q, r):
    return (-r, q + r)

def rotate_k(q, r, k):
    k %= 6
    for _ in range(k):
        q, r = rot_cw(q, r)
    return q, r


def reflect_vert(q, r):
    return (-q - r, r)

data = sys.stdin.read().splitlines()
it = iter(data)

try:
    n_line = next(it)
except StopIteration:
    sys.exit(0)

n = int(n_line.strip())
rows = []
for _ in range(2 * n - 1):
    try:
        line = next(it)
    except StopIteration:
        line = "" 
    vals = [int(x) for x in line.strip().split()]
    rows.append(vals)

ops = ""
try:
    ops = next(it)
except StopIteration:
    ops = ""
ops = ops.strip()

cells = {}
N = n - 1
for idx in range(2 * n - 1):
    r = idx - N
    q_min = max(-N, -r - N)
    q_max = min(N, -r + N)
    expected_len = q_max - q_min + 1
    vals = rows[idx]
    if len(vals) != expected_len:
        vals = (vals + [0] * expected_len)[:expected_len]
    q = q_min
    for v in vals:
        cells[(q, r)] = v
        q += 1

k = 0          
flipped = 0    

for ch in ops:
    if ch == 'R':
        k = (k + 1) % 6
    elif ch == 'L':
        k = (k - 1) % 6
    elif ch == 'T':
        k = (-k) % 6
        flipped ^= 1

def apply_transform(q, r):
    if flipped:
        q, r = reflect_vert(q, r)
    return rotate_k(q, r, k)

out_cells = {}
for (q, r), v in cells.items():
    q2, r2 = apply_transform(q, r)
    out_cells[(q2, r2)] = v

out_lines = []
for idx in range(2 * n - 1):
    r = idx - N
    q_min = max(-N, -r - N)
    q_max = min(N, -r + N)
    line_vals = [str(out_cells[(q, r)]) for q in range(q_min, q_max + 1)]
    out_lines.append(" ".join(line_vals))

sys.stdout.write("\n".join(out_lines))
