WHITES = [ "A","B","C","D","E","F","G" ]
KEYS = [WHITES[i % 7] for i in range(52)]  # буква на позиции 0..51

def next_reach(reach, want_letter):
    # скользящая сумма в окне радиуса 3
    n = 52
    pref = [0]*(n+1)
    for i in range(n):
        pref[i+1] = pref[i] + (1 if reach[i] else 0)

    out = [False]*n
    for j in range(n):
        if KEYS[j] != want_letter:
            continue
        L = max(0, j-3)
        R = min(n-1, j+3)
        # есть ли достижимые позиции в окне [L, R]
        if pref[R+1] - pref[L] > 0:
            out[j] = True
    return out

def solve_one(s: str) -> str:
    # стартовые позиции: любая клавиша с буквой s[0]
    reach = [KEYS[i] == s[0] for i in range(52)]
    for ch in s[1:]:
        reach = next_reach(reach, ch)
        if not any(reach):
            return "No"
    return "Yes" if any(reach) else "No"

t = int(input())

for test in range(t):
    s = input()
    print(solve_one(s))