#include <iostream>
#include <vector>
#include <bitset>
#include <unordered_set>

using namespace std;

static const int MOD = 999983;
static const int A = 618023;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    int s0;
    if (!(cin >> n >> s0)) return 0;

    vector<int> seq(n);
    int s = s0;
    for (int i = 0; i < n; ++i) {
        s = (int)((1LL * s * A + 1) % MOD);
        seq[i] = s;
    }

    vector<char> is_query(MOD, 0);
    for (int x : seq) is_query[x] = 1;

    vector<char> flip(MOD, 0);

    vector<char> present(MOD, 0);
    vector<int> elems; elems.reserve(n);

    int answer = 0;

    for (int i = 0; i < n; ++i) {
        int cur = seq[i];

        int eq = ((cur & 1) == 0 && present[cur >> 1]) ? 1 : 0;

        int parity = eq ^ (flip[cur] != 0);

        if (parity == 0) {
            if (!present[cur]) {
                for (int a : elems) {
                    int y = cur + a;
                    if (y < MOD && is_query[y]) flip[y] ^= 1;
                }
                present[cur] = 1;
                elems.push_back(cur);
                ++answer;
            }
        }
    }

    cout << answer;
    return 0;
}
