#include <iostream>
#include <vector>
#include <string>
using namespace std;

struct UVW { int u, v, w; };

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    if (!(cin >> n)) return 0;
    int rows = 2 * n - 1;

    vector<vector<int>> a(rows);
    for (int i = 0; i < rows; ++i) {
        int len = n - abs(i - (n - 1));
        a[i].resize(len);
        for (int j = 0; j < len; ++j) cin >> a[i][j];
    }

    string ops;
    cin >> ops;

    vector<vector<UVW>> coord(rows);
    for (int i = 0; i < rows; ++i) {
        int len = n - abs(i - (n - 1));
        coord[i].resize(len);
        if (i <= n - 1) {
            int v = (n - 1) - i;
            for (int j = 0; j < len; ++j) {
                int u = j;
                coord[i][j] = { u, v, (n - 1) - u - v };
            }
        }
        else {
            int u = i - (n - 1);
            for (int j = 0; j < len; ++j) {
                int v = j;
                coord[i][j] = { u, v, (n - 1) - u - v };
            }
        }
    }

    auto R = [](UVW t) -> UVW { return UVW{ t.v, t.w, t.u }; };
    auto L = [](UVW t) -> UVW { return UVW{ t.w, t.u, t.v }; };
    auto T = [](UVW t) -> UVW { return UVW{ t.w, t.v, t.u }; };

    for (char c : ops) {
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < (int)coord[i].size(); ++j) {
                if (c == 'R') coord[i][j] = R(coord[i][j]);
                else if (c == 'L') coord[i][j] = L(coord[i][j]);
                else                coord[i][j] = T(coord[i][j]);
            }
        }
    }

    vector<vector<int>> b(rows);
    for (int i = 0; i < rows; ++i) {
        b[i].assign(n - abs(i - (n - 1)), 0);
    }

    for (int i = 0; i < rows; ++i) {
        for (int j = 0; j < (int)coord[i].size(); ++j) {
            UVW t = coord[i][j];
            int ii, jj;
            if (t.v >= t.u) {
                ii = (n - 1) - t.v;
                jj = t.u;
            }
            else {
                ii = (n - 1) + t.u;
                jj = t.v;
            }
            b[ii][jj] = a[i][j];
        }
    }

    for (int i = 0; i < rows; ++i) {
        for (int j = 0; j < (int)b[i].size(); ++j) {
            if (j) cout << ' ';
            cout << b[i][j];
        }
        cout << '\n';
    }
    return 0;
}
