#include <iostream>
#include <vector>
#include <string>
#include <cmath>
#include <algorithm>

using namespace std;

struct Cell {
    int q, r;
    int val;
};

struct Trans {
    int a11, a12, a21, a22;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    if (!(cin >> n)) return 0;

    vector<Cell> cells;
    cells.reserve((size_t)n * n * 3);

    for (int i = 0; i < 2 * n - 1; ++i) {
        int rowSize = n - abs(i - (n - 1));
        int r = i - (n - 1);
        for (int j = 0; j < rowSize; ++j) {
            int val;
            cin >> val;
            int q = j - max(0, n - 1 - i);
            cells.push_back({ q, r, val });
        }
    }

    string ops;
    cin >> ops;

    Trans T = { -1, -1, 0, 1 };
    Trans R = { 0, -1, 1, 1 };
    Trans L = { 1, 1, -1, 0 };

    auto apply = [](Trans a, Trans b) {
        return Trans{
            a.a11 * b.a11 + a.a12 * b.a21,
            a.a11 * b.a12 + a.a12 * b.a22,
            a.a21 * b.a11 + a.a22 * b.a21,
            a.a21 * b.a12 + a.a22 * b.a22
        };
        };

    Trans cur = { 1, 0, 0, 1 };

    for (char c : ops) {
        if (c == 'T') cur = apply(T, cur);
        else if (c == 'R') cur = apply(R, cur);
        else if (c == 'L') cur = apply(L, cur);
    }

    vector<vector<int>> grid(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; ++i)
        grid[i].resize(n - abs(i - (n - 1)));

    for (auto& p : cells) {
        int q2 = cur.a11 * p.q + cur.a12 * p.r;
        int r2 = cur.a21 * p.q + cur.a22 * p.r;

        int row = r2 + (n - 1);
        int offset = max(0, n - 1 - row);
        int col = q2 + offset;

        if (row >= 0 && row < 2 * n - 1 &&
            col >= 0 && col < (int)grid[row].size())
            grid[row][col] = p.val;
    }

    for (int i = 0; i < 2 * n - 1; ++i) {
        for (int j = 0; j < (int)grid[i].size(); ++j) {
            if (j) cout << ' ';
            cout << grid[i][j];
        }
        cout << '\n';
    }

    return 0;
}
