#include <iostream>
#include <vector>
#include <set>
#include <map>

using namespace std;

int main() {
    int mod, n;
    cin >> mod >> n;

    vector<int> d(n);
    for (int i = 0; i < n; i++) {
        cin >> d[i];
    }

    if (mod == 0) {
        //  :  
        cout << 1 << endl;
    } else {
        // :  ,   
        set<int> seen(d.begin(), d.end());

        //    1  n,    set
        for (int num = 1; num <= n; num++) {
            if (seen.find(num) == seen.end()) {
                cout << num << endl;
                return 0;
            }
        }

        //    ,   
        map<int, int> freq;
        for (int num : d) {
            freq[num]++;
        }

        int min_freq = n + 1;
        int result = 1;
        for (const auto& [num, count] : freq) {
            if (count < min_freq) {
                min_freq = count;
                result = num;
            }
        }
        cout << result << endl;
    }

    return 0;
}
