MOD = 10**9 + 7

def modinv(a, p=MOD):

    return pow(a, p-2, p)


MAX = 3_000_000
fact = [1] * (MAX + 1)
inv_fact = [1] * (MAX + 1)

for i in range(2, MAX + 1):
    fact[i] = fact[i-1] * i % MOD

inv_fact[MAX] = modinv(fact[MAX])
for i in range(MAX-1, -1, -1):
    inv_fact[i] = inv_fact[i+1] * (i+1) % MOD

def nCr(n, r):
    if r < 0 or r > n:
        return 0
    return fact[n] * inv_fact[r] % MOD * inv_fact[n-r] % MOD

import sys
input = sys.stdin.read
data = input().split()
t = int(data[0])
idx = 1
results = []
for _ in range(t):
    p = int(data[idx]); idx += 1
    m = int(data[idx]); idx += 1
    n = 2*p + m
    total = 0
    for j in range(n):
        s = 0
        max_i = min(p, j)
        for i in range(max_i + 1):
            if j - i > m:
                continue
            term = nCr(p, i) * pow(2, i, MOD) % MOD
            term = term * nCr(m, j - i) % MOD
            s = (s + term) % MOD
        denom = nCr(n, j)
        total = (total + s * modinv(denom)) % MOD
    results.append(str(total))
print("\n".join(results))

