#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
const ll MODULAR = 1'000'000'007LL;

ll power_mod(ll base_val, ll exp_val) {
    ll res = 1 % MODULAR;
    base_val %= MODULAR;
    while (exp_val > 0) {
        if (exp_val & 1) 
            res = (res * base_val) % MODULAR;
        base_val = (base_val * base_val) % MODULAR;
        exp_val >>= 1;
    }
    return res;
}

vector<ll> compute_factorials(int n) {
    vector<ll> fact(n + 1);
    fact[0] = 1;
    for (int i = 1; i <= n; i++) {
        fact[i] = fact[i - 1] * i % MODULAR;
    }
    return fact;
}

vector<ll> compute_inverse_factorials(const vector<ll>& fact) {
    int n = fact.size() - 1;
    vector<ll> inv_fact(n + 1);
    inv_fact[n] = power_mod(fact[n], MODULAR - 2);
    for (int i = n; i > 0; i--) {
        inv_fact[i - 1] = inv_fact[i] * i % MODULAR;
    }
    return inv_fact;
}

vector<ll> compute_powers_of_two(int n) {
    vector<ll> pow2(n + 1);
    pow2[0] = 1;
    for (int i = 1; i <= n; i++) {
        pow2[i] = (pow2[i - 1] * 2) % MODULAR;
    }
    return pow2;
}

ll compute_S(int k, const vector<ll>& pow2, const vector<ll>& fact, const vector<ll>& inv_fact) {
    ll temp_val = pow2[k] * fact[k] % MODULAR;
    ll numerator = temp_val * temp_val % MODULAR;
    int idx = 2 * k + 1;
    return numerator * inv_fact[idx] % MODULAR;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int num_cases;
    if (!(cin >> num_cases)) return 0;
    
    vector<pair<int, int>> test_data(num_cases);
    int max_prime_val = 0;
    
    for (int i = 0; i < num_cases; i++) {
        int p, m;
        cin >> p >> m;
        test_data[i] = {p, m};
        if (p > max_prime_val) max_prime_val = p;
    }
    
    int max_fact_size = 2 * max_prime_val + 1;
    auto factorials = compute_factorials(max_fact_size);
    auto inv_factorials = compute_inverse_factorials(factorials);
    auto powers_of_two = compute_powers_of_two(max_prime_val);
    
    for (const auto& [prime, mult] : test_data) {
        ll term1 = (2LL * prime) % MODULAR * compute_S(prime - 1, powers_of_two, factorials, inv_factorials) % MODULAR;
        ll term2 = (ll)mult % MODULAR * compute_S(prime, powers_of_two, factorials, inv_factorials) % MODULAR;
        ll result = (term1 + term2) % MODULAR;
        cout << result << '\n';
    }
    
    return 0;
}