#include <bits/stdc++.h>
using namespace std;

const int MOD = 1e9 + 7;
const int N = 3000005;

int fact[N], invfact[N];
int pow2[N];

int modpow(int a, int e) {
    int res = 1;
    while (e) {
        if (e & 1) res = 1LL * res * a % MOD;
        a = 1LL * a * a % MOD;
        e >>= 1;
    }
    return res;
}

void precompute() {
    fact[0] = 1;
    for (int i = 1; i < N; i++) {
        fact[i] = 1LL * fact[i-1] * i % MOD;
    }
    invfact[N-1] = modpow(fact[N-1], MOD-2);
    for (int i = N-2; i >= 0; i--) {
        invfact[i] = 1LL * invfact[i+1] * (i+1) % MOD;
    }
    pow2[0] = 1;
    for (int i = 1; i < N; i++) {
        pow2[i] = (pow2[i-1] * 2) % MOD;
    }
}

int main() {
    precompute();
    int t;
    scanf("%d", &t);
    
    while (t--) {
        int p, m;
        scanf("%d%d", &p, &m);
        
        long long ans = 1;
        
        for (int i = 0; i < p; i++) {
            long long numerator = pow2[i + 1];
            numerator = numerator * fact[m + p - 1 - i] % MOD;
            numerator = numerator * fact[p] % MOD;
            
            long long denominator = fact[m + p + 1];
            denominator = denominator * fact[p - 1 - i] % MOD;
            denominator = denominator * (i + 1) % MOD;
            
            ans = (ans + numerator * modpow(denominator, MOD - 2)) % MOD;
        }
        
        printf("%lld\n", ans * 2);
    }
    return 0;
}