#include <bits/stdc++.h>
using namespace std;

struct Point {
    int x, y;
    Point() {}
    Point(int x, int y) : x(x), y(y) {}
    bool operator<(const Point& p) const {
        return x < p.x || (x == p.x && y < p.y);
    }
};

long long cross(const Point& O, const Point& A, const Point& B) {
    return 1LL * (A.x - O.x) * (B.y - O.y) - 1LL * (A.y - O.y) * (B.x - O.x);
}

long long dist2(const Point& A, const Point& B) {
    return 1LL * (A.x - B.x) * (A.x - B.x) + 1LL * (A.y - B.y) * (A.y - B.y);
}

vector<Point> convexHull(vector<Point>& P) {
    int n = P.size();
    if (n <= 1) return P;
    sort(P.begin(), P.end());
    vector<Point> hull;
    for (int i = 0; i < n; ++i) {
        while (hull.size() >= 2 && cross(hull[hull.size()-2], hull.back(), P[i]) <= 0) hull.pop_back();
        hull.push_back(P[i]);
    }
    int lower_size = hull.size();
    for (int i = n-2; i >= 0; --i) {
        while (hull.size() > lower_size && cross(hull[hull.size()-2], hull.back(), P[i]) <= 0) hull.pop_back();
        hull.push_back(P[i]);
    }
    hull.pop_back();
    return hull;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    int n;
    cin >> n;
    vector<Point> points;
    for (int i = 0; i < n; i++) {
        int x, y;
        cin >> x >> y;
        points.push_back(Point(x, y));
    }
    vector<Point> hull = convexHull(points);
    int m = hull.size();
    long long max_d2 = 0;
    Point A, B;
    for (int i = 0; i < m; i++) {
        for (int j = i+1; j < m; j++) {
            long long d2 = dist2(hull[i], hull[j]);
            if (d2 > max_d2) {
                max_d2 = d2;
                A = hull[i];
                B = hull[j];
            }
        }
    }
    int dx = B.x - A.x;
    int dy = B.y - A.y;
    cout << dx << " " << dy << " " << -dx*A.x - dy*A.y << "\n";
    cout << dx << " " << dy << " " << -dx*B.x - dy*B.y << "\n";
    return 0;
}