#include <bits/stdc++.h>
using namespace std;

class SegmentTree {
    int n;
    vector<int> tree;

public:
    SegmentTree(int n) : n(n), tree(4 * n, 0) {}

    void build(int v, int tl, int tr) {
        if (tl == tr) {
            tree[v] = 1;
            return;
        }
        int tm = (tl + tr) / 2;
        build(v * 2, tl, tm);
        build(v * 2 + 1, tm + 1, tr);
        tree[v] = tree[v * 2] + tree[v * 2 + 1];
    }

    void build() { build(1, 0, n - 1); }

    void occupy(int v, int tl, int tr, int pos) {
        if (tl == tr) {
            tree[v] = 0;
            return;
        }
        int tm = (tl + tr) / 2;
        if (pos <= tm)
            occupy(v * 2, tl, tm, pos);
        else
            occupy(v * 2 + 1, tm + 1, tr, pos);
        tree[v] = tree[v * 2] + tree[v * 2 + 1];
    }

    void occupy(int pos) { occupy(1, 0, n - 1, pos); }

    int find_kth(int v, int tl, int tr, int k) {
        if (tl == tr)
            return tl;
        int tm = (tl + tr) / 2;
        if (tree[v * 2] > k)
            return find_kth(v * 2, tl, tm, k);
        else
            return find_kth(v * 2 + 1, tm + 1, tr, k - tree[v * 2]);
    }

    int find_kth(int k) { return find_kth(1, 0, n - 1, k); }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<int> a(n);
    for (int i = 0; i < n; ++i)
        cin >> a[i];

    SegmentTree st(n);
    st.build();

    vector<int> res(n, 0);

    for (int i = 0; i < n; ++i) {
      int pos = st.find_kth(n - i - 1 - a[i]);
      res[pos] = i + 1;
      st.occupy(pos);
    }

    for (int i = 0; i < n; ++i)
        cout << res[i] << " ";
    cout << "\n";
}
