import sys
import math


def polygon_area(points):
    s = 0
    n = len(points)
    for i in range(n):
        x1, y1 = points[i]
        x2, y2 = points[(i + 1) % n]
        s += x1 * y2 - y1 * x2
    return abs(s) * 0.5


def main():
    data = list(map(int, sys.stdin.read().split()))
    if len(data) != 8:
        return
    x1, y1, x2, y2, x3, y3, x4, y4 = data
    rect = [(x1, y1), (x2, y2), (x3, y3), (x4, y4)]

    rect_area = polygon_area(rect)
    ell_area = (math.pi / 4.0) * rect_area
    print(f"{ell_area:.8f}")


if __name__ == "__main__":
    main()

