import sys

def read_hex(n):
    R = n - 1
    rows = []
    for i in range(2 * n - 1):
        need = n + min(i, 2 * n - 2 - i)
        vals = []
        while len(vals) < need:
            line = sys.stdin.readline()
            if not line:
                break
            vals += list(map(int, line.split()))
        rows.append(vals[:need])
    return rows

def reduce_ops(ops: str):
    ops = "".join(ch for ch in ops if ch in "TLR")
    ref = 0
    k = 0
    for ch in ops:
        if ch == 'R':
            k += 1 if ref == 0 else -1
        elif ch == 'L':
            k += -1 if ref == 0 else 1
        else:
            ref ^= 1
            k = -k
    return ref, (k % 6)

def rot_cw(x, y, z):
    return (-z, -x, -y)

def apply_transform(n, a, ref, k):
    R = n - 1
    out = [[0] * (n + min(i, 2 * n - 2 - i)) for i in range(2 * n - 1)]
    for i in range(2 * n - 1):
        y = R - i
        Lx = max(-R, -y - R)
        for j, val in enumerate(a[i]):
            x = Lx + j
            z = -x - y

            x1, y1, z1 = x, y, z
            kk = k
            while kk:
                x1, y1, z1 = rot_cw(x1, y1, z1)
                kk -= 1
            if ref:
                x1, y1 = y1, x1
            i2 = R - y1
            Lx2 = max(-R, -y1 - R)
            j2 = x1 - Lx2
            out[i2][j2] = val
    return out

def main():
    line = sys.stdin.readline()
    if not line:
        return
    n = int(line.split()[0])
    a = read_hex(n)
    ops = sys.stdin.readline() or ""
    ref, k = reduce_ops(ops)
    res = apply_transform(n, a, ref, k)
    print("\n".join(" ".join(map(str, row)) for row in res))

main()
