import sys

LET = ['A','B','C','D','E','F','G']
KEYS = [LET[i % 7] for i in range(52)]
MASK = {ch: [1 if k == ch else 0 for k in KEYS] for ch in LET}

def can_play(s: str) -> bool:
    s = s.strip().upper()
    if not s:
        return True
    cur = MASK[s[0]][:]
    for ch in s[1:]:
        ps = [0] * 53
        for i, v in enumerate(cur, 1):
            ps[i] = ps[i-1] + v
        reach = [0] * 52
        for j in range(52):
            L = j - 3 if j >= 3 else 0
            R = j + 3 if j <= 48 else 51
            if ps[R+1] - ps[L] > 0:
                reach[j] = 1
        m = MASK[ch]
        cur = [reach[i] & m[i] for i in range(52)]
        if not any(cur):
            return False
    return any(cur)

def main():
    try:
        t = int(input().strip())
    except Exception:
        return
    for _ in range(t):
        s = input().strip()
        print("Yes" if can_play(s) else "No", flush=True)


main()
