#include <iostream>
#include <string>
#include <vector>
#include <math.h>
#include <algorithm>
#include <tuple>

using namespace std;

long long int gcd(long long int a, long long int b)
{
    while (b != 0) {
        int temp = b;
        b = a % b;
        a = temp;
    }
    return a;
}
long long int lcm(long long int a, long long int b)
{
    return a * b / gcd(a, b);
}

struct Point 
{
    double x, y;

    Point(double x = 0, double y = 0) : x(x), y(y) {}

    Point operator - (const Point& p) const {
        return Point(x - p.x, y - p.y);
    }

    bool operator < (const Point& p) const {
        return x < p.x || (x == p.x && y < p.y);
    }
};

double cross(const Point& a, const Point& b) {
    return a.x * b.y - a.y * b.x;
}

double cross(const Point& a, const Point& b, const Point& c) {
    return cross(b - a, c - a);
}

double dist2(const Point& a, const Point& b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

pair<Point, Point> farthestPoints(vector<Point> points) {
    int n = points.size();
    if (n <= 1) return { points[0], points[0] };

    // Строим выпуклую оболочку
    sort(points.begin(), points.end());

    vector<Point> hull;
    for (int i = 0; i < n; i++) {
        while (hull.size() >= 2 &&
            cross(hull[hull.size() - 2], hull.back(), points[i]) <= 0) {
            hull.pop_back();
        }
        hull.push_back(points[i]);
    }

    int lower_size = hull.size();
    for (int i = n - 2; i >= 0; i--) {
        while (hull.size() > lower_size &&
            cross(hull[hull.size() - 2], hull.back(), points[i]) <= 0) {
            hull.pop_back();
        }
        hull.push_back(points[i]);
    }
    hull.pop_back();

    // Вращающиеся калиперы
    n = hull.size();
    if (n == 1) return { hull[0], hull[0] };

    double max_dist2 = 0;
    pair<Point, Point> result;

    for (int i = 0, j = 1; i < n; i++) {
        while (true) {
            int next_j = (j + 1) % n;
            Point v1 = hull[(i + 1) % n] - hull[i];
            Point v2 = hull[next_j] - hull[j];

            if (cross(v1, v2) < 0) break;
            j = next_j;
        }

        double d2 = dist2(hull[i], hull[j]);
        if (d2 > max_dist2) {
            max_dist2 = d2;
            result = { hull[i], hull[j] };
        }
    }

    return result;
}
int main()
{
    int n,xi,yi;
    
    vector <int> xg(4), yg(4);

    cin >> n;
    vector<Point>points(n);
    
    /*cin >> xi >> yi;
    xg[0] = xi; xg[1] = xi;
    yg[2] = yi; yg[3] = yi;*/
    for (int i = 0; i < n; i++)
    {
        cin >> points[i].x >> points[i].y;
        
    }
    Point p1, p2;
    if (n > 2)
        tie(p1, p2) = farthestPoints(points);
    else
    {
        p1 = points[0];
        p2 = points[1];
    }
    double D;
    long int x1, x2, y1, y2;
    if (p1.x < p2.x)
    {
        x1 = p1.x; x2 = p2.x; y1 = p1.y; y2 = p2.y;
    }
    else
    {
        x2 = p1.x, x1 = p2.x, y2 = p1.y, y1 = p2.y;
    }
    long int dx = x2 - x1, dy = y2-y1;
    //cout << x1 << " " << y1 << " " << x2 << " " << y2 << endl;
    long long int a1,b1,c1,a2,b2,c2,gcd1,gcd2;
    b1 = dy; b2 = dy;
    a1 = dx; a2 = dx;
    c1 = (y1 * dy + x1 * dx);
    c2 = (y2 * dy + x2 * dx);
    gcd1 = gcd(gcd(a1, b1), c1);
    gcd2 = gcd(gcd(a2, b2), c2);
    a1 /= gcd1; b1 /= gcd1; c1 /= -gcd1;
    a2 /= gcd2; b2 /= gcd2; c2 /= -gcd2;
    cout << a1 << " " << b1 << " " << c1 << endl;
    cout << a2 << " " << b2 << " " << c2 << endl;
        //cout << k1 << " " << k2 << endl;
}