#include<bits/stdc++.h>
using namespace std;

const long long MOD = 1e9 + 7;

long long mod_pow(long long a, long long b) {
    long long r = 1;
    for (a %= MOD; b; b >>= 1) {
        if (b & 1) r = r * a % MOD;
        a = a * a % MOD;
    }
    return r;
}

inline long long inv(long long a) {
    return mod_pow(a, MOD - 2);
}

int p, m, n;
unordered_map<long long, long long> dp;

inline long long encode(int i, int j) {
    return ((long long)i << 20) | j;
}

long long solve(int i, int j) {
    if (i > p || j > m) return 0;

    long long key = encode(i, j);
    if (dp.count(key)) return dp[key];

    int r = n - i - j;
    if (r <= 0) return 0;

    long long ans = 1;
    long long inv_r = inv(r);

    // Contribution from pair socks
    if (i < p) {
        long long np = 2 * (p - i);
        ans = (ans + np * inv_r % MOD * solve(i + 1, j)) % MOD;
    }

    // Contribution from single socks
    if (j < m) {
        long long ns = m - j;
        ans = (ans + ns * inv_r % MOD * solve(i, j + 1)) % MOD;
    }

    return dp[key] = ans;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int t;
    cin >> t;

    while (t--) {
        cin >> p >> m;
        n = 2 * p + m;
        dp.clear();

        cout << solve(0, 0) << "\n";
    }

    return 0;
}
