def press(op: str) -> int:
    print(op, flush=True)
    y = int(input().strip())
    if y == 0:
        raise SystemExit 
    return y

def play_round(x: int) -> None:
    while x != 1:
        if (x % 2) == 0:
            x = press("collatz")           
        else:
            if (x % 4) == 3:               
                x = press("random")        
                if x != 1 and (x & 1) == 1:
                    x = press("random")    
            else:
                x = press("collatz")

def main():
    t = int(input().strip())
    for _ in range(t):
        x0 = int(input().strip())
        play_round(x0)

if __name__ == "__main__":
    main()

