#include <iostream>
using namespace std;

bool is_power_of_two(long long n) {
    return (n & (n - 1)) == 0;
}

bool should_use_random(long long n) {
    if (n % 2 == 0) return false;
    
    long long min_r = 3LL * n + 1;
    long long max_r = 6LL * n;
    
    long long power = 1;
    while (power < min_r) {
        power <<= 1;
    }
    
    return power <= max_r;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int t;
    cin >> t;
    
    while (t--) {
        long long x;
        cin >> x;
        
        while (x > 1) {
            if (x % 2 == 0) {
                cout << "collatz" << endl;
            } else {
                if (should_use_random(x)) {
                    cout << "random" << endl;
                } else {
                    cout << "collatz" << endl;
                }
            }
            
            cout.flush();
            cin >> x;
            
            if (x == 0) return 0;
            if (x == 1) break;
        }
    }
    
    return 0;
}