THRESH = 1_000_000
GOOD_HALVES = 3
MAX_R = 3

def press(op: str) -> int:
    print(op, flush=True)
    y = int(input().strip())
    if y == 0:
        raise SystemExit
    return y

def eat_powers_of_two(x: int) -> tuple[int, int]:
    halves = 0
    while x > 1 and (x & 1) == 0:
        x = press("collatz")
        halves += 1
    return x, halves

def solve_round(x: int) -> None:
    x, _ = eat_powers_of_two(x)
    while x > 1:
        if (x & 1) == 1:
            if x >= THRESH:
                tries = 0
                while x >= THRESH and tries < MAX_R:
                    x = press("random")
                    x, d = eat_powers_of_two(x)
                    tries += 1
                    if d >= GOOD_HALVES or x < THRESH or x == 1:
                        break
                if x == 1:
                    return
                if (x & 1) == 0:
                    continue
            x = press("collatz")
            x, _ = eat_powers_of_two(x)
        else:
            x, _ = eat_powers_of_two(x)

def main():
    t = int(input().strip())
    for _ in range(t):
        x0 = int(input().strip())
        solve_round(x0)

if __name__ == "__main__":
    main()
