import sys
def read_int():
    s = sys.stdin.readline()
    if not s:
        sys.exit(0)
    return int(s.strip())

def flush_print(cmd):
    print(cmd)
    sys.stdout.flush()

def v2(n: int) -> int:
    return (n & -n).bit_length() - 1

def solve():
    t = read_int()
    for _ in range(t):
        x = read_int()
        random_left = 20

        while True:
            if x == 0:
                return
            if x == 1:
                break

            if (x & 1) == 0:
                flush_print("collatz")
                x = read_int()
            else:
                if random_left > 0:
                    r = v2(3 * x + 1)
                    if r >= 4:
                        flush_print("random")
                        random_left -= 1
                        x = read_int()
                        continue
                flush_print("collatz")
                x = read_int()

if __name__ == "__main__":
    solve()
