#include <iostream>
#include <string>
using namespace std;

bool should_use_random(long long n) {
    if (n % 2 == 0) return false;
    if (n > 1000000LL) return false;
    long long min_r = 3LL * n + 1;
    long long max_r = 6LL * n;
    for (long long pow2 = 4; pow2 <= max_r && pow2 > 0; pow2 <<= 1) {
        if (pow2 >= min_r) return true;
    }
    return false;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int t;
    cin >> t;
    while (t--) {
        long long x;
        cin >> x;
        while (x > 1) {
            if (should_use_random(x)) {
                cout << "random" << endl;
                cout.flush();
                cin >> x;
                if (x == 0) return 0;
                if (x == 1) break;
            } else {
                cout << "collatz" << endl;
                cout.flush();
                cin >> x;
                if (x == 0) return 0;
                if (x == 1) break;
            }
        }
    }
    return 0;
}
