import sys
import random

sys.setrecursionlimit(1 << 25)
rand = random.Random(0xC0FFEE)  

class Node:
    __slots__ = ("val", "prio", "left", "right", "sz")
    def __init__(self, val):
        self.val = val
        self.prio = rand.randrange(1 << 30)
        self.left = None
        self.right = None
        self.sz = 1

def size(t):
    return t.sz if t else 0

def pull(t):
    if t:
        t.sz = 1 + size(t.left) + size(t.right)

def split(t, k):
    if not t:
        return (None, None)
    if size(t.left) >= k:
        L, t.left = split(t.left, k)
        pull(t)
        return (L, t)
    else:
        k2 = k - size(t.left) - 1
        t.right, R = split(t.right, k2)
        pull(t)
        return (t, R)

def merge(a, b):
    if not a or not b:
        return a or b
    if a.prio > b.prio:
        a.right = merge(a.right, b)
        pull(a)
        return a
    else:
        b.left = merge(a, b.left)
        pull(b)
        return b

def inorder(t, out):
    if not t:
        return
    inorder(t.left, out)
    out.append(t.val)
    inorder(t.right, out)

def solve():
    n = int(input())
    a = list(map(int, input().split()))
    root = None
    for i in range(n, 0, -1):
        t = size(root)
        r = t - a[i-1]  
        if r < 0 or r > t:
            r = max(0, min(r, t))
        L, R = split(root, r)
        node = Node(i)
        root = merge(merge(L, node), R)

    ans = []
    inorder(root, ans)
    print(*ans)

if __name__ == "__main__":
    solve()
