#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

struct Point {
    long long x, y;
};

long long dist_sq(const Point& a, const Point& b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

void solve() {
    int n;
    if (!(cin >> n)) return;

    vector<Point> points(n);
    for (int i = 0; i < n; ++i) {
        cin >> points[i].x >> points[i].y;
    }

    if (n < 2) return;

    long long max_d2 = -1;
    Point P1 = points[0];
    Point P2 = points[1];

    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            long long cur_d2 = dist_sq(points[i], points[j]);
            if (cur_d2 > max_d2) {
                max_d2 = cur_d2;
                P1 = points[i];
                P2 = points[j];
            }
        }
    }
    long long A = P2.x - P1.x;
    long long B = P2.y - P1.y;

    if (A == 0 && B == 0) {
        cout << 1 << " " << 0 << " " << -P1.x << endl;
        cout << 1 << " " << 0 << " " << -P1.x - 1 << endl;
        return;
    }

    long long max_val = A * points[0].x + B * points[0].y;
    long long min_val = max_val;

    for (int i = 1; i < n; ++i) {
        long long cur_val = A * points[i].x + B * points[i].y;
        max_val = max(max_val, cur_val);
        min_val = min(min_val, cur_val);
    }

    long long C1 = -min_val;
    long long C2 = -max_val;

    if (C1 > C2) {
        swap(C1, C2);
    }

    cout << A << " " << B << " " << C1 << endl;
    cout << A << " " << B << " " << C2 << endl;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    solve();

    return 0;
}