﻿#include <iostream>
#include <vector>

using namespace std;

using ll = long long;

ll MOD = 1e9 + 7;

ll power(ll base, ll exp) {
    ll res = 1;
    base %= MOD;
    while (exp > 0) {
        if (exp % 2 == 1) res = (res * base) % MOD;
        base = (base * base) % MOD;
        exp /= 2;
    }
    return res;
}

ll modInverse(ll n) {
    return power(n, MOD - 2);
}

const int MAXN = 2000005;
vector<ll> fact(MAXN);

void precompute_factorials() {
    fact[0] = 1;
    for (int i = 1; i < MAXN; i++) {
        fact[i] = (fact[i - 1] * i) % MOD;
    }
}

ll solve() {
    ll p, m;
    cin >> p >> m;

    ll term1 = (m + 2 * p + 1) % MOD;

    ll term_4p = power(4, p);

    ll p_fact = fact[p];
    ll p_fact_sq = (p_fact * p_fact) % MOD;

    ll fact_2p1 = fact[2 * p + 1];

    ll numerator = (term1 * term_4p) % MOD;
    numerator = (numerator * p_fact_sq) % MOD;

    ll denominator_inv = modInverse(fact_2p1);

    ll ans = (numerator * denominator_inv) % MOD;
    return ans;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    precompute_factorials();

    int t;
    cin >> t;
    while (t--) {
        cout << solve() << "\n";
    }
    return 0;
}