﻿#include <iostream>
#include <vector>
#include <bitset> 

const int M = 999983;
static std::bitset<M> V_exists;

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int n;
    long long s_ll;
    std::cin >> n >> s_ll;

    const long long A = 618023LL;
    const long long C = 1LL;

    std::vector<int> V_elements;
    V_elements.reserve(n);

    for (int i = 0; i < n; ++i) {
        s_ll = (s_ll * A + C) % M;
        int s = (int)s_ll;

        int pair_count = 0;
        int s_limit = s / 2;
        int k = V_elements.size();

        if (k < s_limit) {
            for (int a : V_elements) {
                if (a > s) {
                    continue;
                }

                int b = s - a;
                if (b < a) {
                    continue;
                }
                if (V_exists[b]) {
                    pair_count++;
                }
            }
        }
        else {
            for (int a = 0; a <= s_limit; ++a) {
                // a и s-a 100% в [0, M-1]
                if (V_exists[a] && V_exists[s - a]) {
                    pair_count++;
                }
            }
        }

        if (pair_count % 2 == 0) {
            if (!V_exists[s]) {
                V_exists[s] = 1;
                V_elements.push_back(s);
            }
        }
    }

    std::cout << V_elements.size() << "\n";
    return 0;
}