﻿#include <iostream>
#include <vector>
#include <bitset>

using namespace std;

const int MOD = 999983;

static bitset<MOD> exists;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    long long n;
    long long s;
    cin >> n >> s;

    const long long mult = 618023;

    // Compute the period p
    long long current = (s * mult + 1) % MOD;
    long long first = current;
    int p = 0;
    do {
        current = (current * mult + 1) % MOD;
        p++;
    } while (current != first && p <= MOD);

    vector<int> V_list;
    V_list.reserve(MOD);

    int v_size = 0;

    long long i = 0;
    long long last_add = -1;

    while (i < n) {
        s = (s * mult + 1) % MOD;
        i++;
        if (i > n) break;
        const int s_int = static_cast<int>(s);
        if (exists.test(s_int)) {
            if (i - last_add > p) break;
            continue;
        }
        const int s_half = s_int / 2;
        int count_parity = 0;
        if (v_size < s_half) {
            const int* current_v = V_list.data();
            const int* end_v = V_list.data() + v_size;
            while (current_v != end_v) {
                const int a = *current_v++;
                if (a > s_half) continue;
                if (exists.test(s_int - a)) count_parity ^= 1;
            }
        }
        else {
            for (int a = 0; a < s_half; ++a) {
                if (exists.test(a) && exists.test(s_int - a)) count_parity ^= 1;
            }
            if ((s_int & 1) == 0) {
                if (exists.test(s_half)) count_parity ^= 1;
            }
        }
        if (count_parity == 0) {
            exists.set(s_int);
            V_list.push_back(s_int);
            v_size++;
            last_add = i;
        }
        if (i - last_add > p) break;
    }

    cout << v_size << "\n";

    return 0;
}