﻿#include <iostream>
#include <vector>
#include <bitset>

using namespace std;

const int MOD = 999983;

static bitset<MOD> exists;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    long long s;
    cin >> n >> s;

    const long long mult = 618023;

    vector<int> V_list;

    V_list.reserve(n);

    int v_size = 0;

    for (int i = 0; i < n; ++i) {
        s = (s * mult + 1) % MOD;
        const int s_int = static_cast<int>(s);
        const int s_half = s_int / 2;

        int count_parity = 0;

        if (v_size < s_half) {

            const int* current_v = V_list.data();
            const int* end_v = V_list.data() + v_size;

            while (current_v != end_v) {
                const int a = *current_v++;

                if (a > s_half) {
                    continue;
                }

                if (exists.test(s_int - a)) {
                    count_parity ^= 1;
                }
            }
        }
        else {
            for (int a = 0; a < s_half; ++a) {
                if (exists.test(a) && exists.test(s_int - a)) {
                    count_parity ^= 1;
                }
            }

            if ((s_int & 1) == 0) {
                if (exists.test(s_half)) {
                    count_parity ^= 1;
                }
            }
        }

        if (count_parity == 0) {
            if (!exists.test(s_int)) {
                exists.set(s_int);
                V_list.push_back(s_int);
                v_size++;
            }
        }
    }

    cout << v_size << "\n";

    return 0;
}