﻿#include <iostream>
#include <string>
#include <algorithm>
#include <cmath>

using namespace std;

string reverse_binary(string s) {
    reverse(s.begin(), s.end());
    // Удаляем ведущие нули
    size_t pos = s.find('1');
    if (pos != string::npos) {
        s = s.substr(pos);
    }
    else {
        s = "0";
    }
    return s;
}

string subtract_one(string s) {
    int i = s.length() - 1;
    while (i >= 0 && s[i] == '0') {
        s[i] = '1';
        i--;
    }
    if (i >= 0) {
        s[i] = '0';
    }

    size_t pos = s.find('1');
    if (pos != string::npos) {
        s = s.substr(pos);
    }
    else {
        s = "0";
    }
    return s;
}

int main() {
    int n;
    cin >> n;

    if (n == 0) {
        cout << 0 << endl;
        return 0;
    }

    string binary = "";
    while (n > 0) {
        binary = char('0' + (n % 2)) + binary;
        n /= 2;
    }

    int count = 0;
    while (binary != "0") {
        count++;
        binary = reverse_binary(binary);
        binary = subtract_one(binary);
    }

    cout << count << endl;
    return 0;
}