import sys
import random

def should_use_random(x):
    if x <= 1000:
        return False
    if (x & (x - 1)) == 0:
        return False
    if x % 3 == 1 and x > 10000:
        return random.random() < 0.4
    if x > 5 * 10**6:
        return random.random() < 0.2
    return False

def main():
    t = int(sys.stdin.readline())
    
    for _ in range(t):
        x = int(sys.stdin.readline())
        
        while x != 1:
            if should_use_random(x):
                print("random")
            else:
                print("collatz")
            sys.stdout.flush()
            
            x = int(sys.stdin.readline())
            if x == 0:
                return

if __name__ == "__main__":
    main()
