import sys

def can_play(s, pos):
    possible = set(pos[s[0]])
    for ch in s[1:]:
        newp = set()
        for idx in pos[ch]:
            for p in possible:
                if abs(p - idx) <= 3:
                    newp.add(idx)
                    break
        if not newp:
            return False
        possible = newp
    return True

def main():
    data = sys.stdin
    line = data.readline()
    while line and line.strip() == "":
        line = data.readline()
    if not line:
        return
    t = int(line.strip())

    seq = "ABCDEFG"
    pos = {c: [] for c in seq}
    for i in range(52):
        pos[seq[i % 7]].append(i)

    out_lines = []
    for _ in range(t):
        s = data.readline()
        while s is not None and s.strip() == "":
            s = data.readline()
            if s == "":
                break
        if not s:
            break
        s = s.strip()
        out_lines.append("Yes" if can_play(s, pos) else "No")

    print("\n".join(out_lines))

if __name__ == "__main__":
    main()
