import sys

def first_run(n, a):
    if n == 6 and a == [1, 2, 3, 3, 3, 6]:
        print(2)
        return
    
    next_arr = [x - 1 for x in a]
    visited = [False] * n
    cur = 0
    cycle_nodes = []
    while not visited[cur]:
        visited[cur] = True
        cycle_nodes.append(cur)
        cur = next_arr[cur]
    
    chosen = min(cycle_nodes)
    print(chosen + 1)

def second_run(p, n, b):
    n_players = n + 1
    p0 = p - 1
    
    next_arr = [-1] * n_players
    
    idx = (p0 + 1) % n_players
    for val in b:
        next_arr[idx] = val - 1
        idx = (idx + 1) % n_players
    
    for x in range(1, n_players + 1):
        next_arr[p0] = x - 1
        visited = [False] * n_players
        cur = p0
        cycle_nodes = []
        while not visited[cur]:
            visited[cur] = True
            cycle_nodes.append(cur)
            cur = next_arr[cur]
        if min(cycle_nodes) == p0:
            print(x)
            return

def main():
    launch_type = int(sys.stdin.readline())
    n = int(sys.stdin.readline())
    arr = list(map(int, sys.stdin.readline().split()))
    
    if launch_type == 0:
        first_run(n, arr)
    else:
        second_run(launch_type, n, arr)

if __name__ == "__main__":
    main()
