import java.io.*;

public class Main {
    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String[] in = br.readLine().split(" ");
        int n = Integer.parseInt(in[0]);
        int s = Integer.parseInt(in[1]);
        final int MOD = 999_983;
        final long A = 618_023L;

        boolean[] inV = new boolean[MOD];
        int[] V = new int[n];
        int cnt = 0;

        for (int step = 0; step < n; step++) {
            s = (int) ((s * A + 1) % MOD);

            // Быстрая проверка: есть ли a ∈ V такое, что (s - a) ∈ V и a <= s - a
            boolean conflict = false;
            for (int i = 0; i < cnt; i++) {
                int a = V[i];
                if (a > s) continue; // тогда b = s - a < 0
                int b = s - a;
                if (a <= b && inV[b]) {
                    conflict = true;
                    break; // достаточно одной пары!
                }
            }

            if (!conflict && !inV[s]) {
                inV[s] = true;
                V[cnt++] = s;
            }
        }

        System.out.println(cnt);
    }
}