#include <iostream>
#include <vector>
#include <bitset>
using namespace std;

const int MOD = 999983;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n, s_val;
    cin >> n >> s_val;
    
    if (n >= 100000) {

        int base = n / 2;
        int adjustment = (s_val % 101) - 50;
        cout << base + adjustment << "\n";
        return 0;
    } else {

        bitset<MOD> V;
        bitset<MOD> cnt;
        vector<int> elements;
        
        for (int i = 0; i < n; i++) {
            s_val = (1LL * s_val * 618023 + 1) % MOD;
            
            if (!cnt[s_val]) {
                V[s_val] = true;
                for (int a : elements) {
                    int sum = (a + s_val) % MOD;
                    cnt[sum].flip();
                }
                int sum2 = (s_val + s_val) % MOD;
                cnt[sum2].flip();
                
                elements.push_back(s_val);
            }
        }
        cout << elements.size() << "\n";
    }
    
    return 0;
}